#include <ESP8266WiFi.h>
#include <WiFiUdp.h>
#include <MPU6050_tockn.h>    // include MPU6050 library
#include <Wire.h>             // include I2C library

WiFiUDP client;               // UDP object

MPU6050 mpu6050(Wire);        // declare a sensor object

long timer = 0;               // variable used to set the sensor sample rate
char buf[64];                 // buffer for creating text

void setup() {
  Serial.begin(115200);       // set up serial interface
  Wire.begin(4,5);            // set up I2C interface
  mpu6050.begin(ACCEL_2G,GYRO_500);   // configure the sensor
  mpu6050.calcGyroOffsets(true);  // don't move sensor when this function runs
  WiFi.mode(WIFI_AP);         // set up WiFi for access point
  WiFi.softAP("UDPIMU");
}

void loop() { 
  if(millis() - timer > 100) {    // if timer greater than 100 ms
    mpu6050.update();             // get update of sensor values
   timer = millis();              // reset timer
    snprintf(buf,64,"%f,%f,%f\n",mpu6050.getAngleX(),mpu6050.getAngleY(),mpu6050.getAngleZ());  // get angles
    Serial.print(buf);
    client.beginPacket("192.168.4.2",3000);   // start udp packet to destination IP and port
    client.write(buf);                        // send string
    client.endPacket();                       // end packet which sends the packet
  }
}
