import hypermedia.net.*;    // UDP library

UDP p;                      // declare UDP object

String message;             // declare global string

void setup() {
  size(800, 700, P3D);        // open window for 3D rendering
  p = new UDP(this, 3000);   // set up UDP port 
  p.listen(true);           // listen for UDP packets
}

void draw() {
  if (message != null) {        // check if string has data
    spotLight(255, 0, 0, 500, 0, 0, -1, 0, 0, 50, 1);    // set up red spot light
    spotLight(0, 255, 0, 0, 500, 0, 0, -1, 0, 50, 1);    // set up green spot light
    spotLight(0, 0, 255, 0, 0, 500, 0, 0, -1, 50, 2);    // set up blue spot light
    camera(50, 500, 50, 0, 0, 0, 0, 0, 1);               // set up camera to point to center
    String[] dat = message.split(",");                   // split X,Y,Z values from string
    float x = float(dat[0])/360.0 * 6.28;                // convert angle to radians
    float y = float(dat[1]) /360.0 * 6.28;
    float z = float(trim(dat[2])) / 360.0 * 6.28;
    println(x + " " + y + " " + z);                      // print values
    background(0);                                       // clear window and set background to black
    pushMatrix();                                // set up matrix
    rotateY(y);                                  // rotate box around Y axis
    rotateX(x);                                  // rotate box around X axis
    rotateZ(z);                                  // rotate box around Z axis
    fill(250, 250, 250);                         // set box to white
    box(100, 100, 50);                           // render box
    popMatrix();                                 // exit matrix
  }
}

void receive( byte[] data, String ip, int port ) {  // event function executes when UDP packet is received
  message = new String( data );  // convert byte array to String
}
